package jumpstart.max.web.pages.security;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;

public abstract class UserRoleViewPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(UserRoleViewPage.class);
	static public final String PAGE_NAME = "pages/security/UserRoleViewPage";

	@Persist("client:form")
	public abstract Long getUserRoleId();
	public abstract void setUserRoleId(Long value);

	@Persist("client:form")
	public abstract UserRole getUserRole();
	public abstract void setUserRole(UserRole value);

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setUserRoleId(id);

		// Get the UserRole

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		UserRole userRole = securityFinder.findUserRoleShallowish(id);
		setUserRole(userRole);

		getRequestCycle().activate(this);
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
