package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;

public abstract class UserViewPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(UserViewPage.class);
	static public final String PAGE_NAME = "pages/security/UserViewPage";

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract Long getUserId();
	public abstract void setUserId(Long value);

	@Persist("session")
	// Probably best not to use client persistence, even though it encodes the
	// field, because User includes password
	public abstract User getUser();
	public abstract void setUser(User value);

	@Persist("client:form")
	public abstract List<UserRole> getUserRoles();
	public abstract void setUserRoles(List<UserRole> value);
	public abstract UserRole getUserRole();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setUserId(id);

		// Get the User

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		User user = securityFinder.findUserShallowish(id);
		setUser(user);

		// Put a list of userRoles onto the page

		listUserRoles();

		getRequestCycle().activate(this);
	}

	public void doCancel() {
		popAndActivateCallback();
	}

	private void listUserRoles() {

		// Put a list of userRoles on the page

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		List<UserRole> l = securityFinder.findUserRolesShallowishByUser(getUser().getId());
		setUserRoles(l);
	}

	public void doViewUserRole(Long id) {

		try {
			UserRoleViewPage nextPage = (UserRoleViewPage) getRequestCycle().getPage(UserRoleViewPage.PAGE_NAME);
			nextPage.activate(id);
			pushExternalCallback(this, new Object[] { getUserId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

}
