package jumpstart.max.web.state;

import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;

import org.apache.tapestry.form.translator.DateTranslator;

@SuppressWarnings("serial")
public class Visit implements Serializable {

	private boolean _loggedIn = false;

	// The logged in user
	// - Note this is a security risk because User holds a clear-text password.
	// Solutions include keeping password encrypted in User; moving password
	// out of User into a separate entity; using third-party authentication;
	// holding only those fields from User that we'll use in here.
	private User _myUser = null;
	private List<Long> _myActiveRoleIds = null;

	// Date translator - for inputting dates
	private DateTranslator _myDateTranslator;

	// Date and time view formatters - for outputting dates
	private Format _myDateViewFormat;

	// Date and time list formatters - for outputting dates in a list
	private Format _myDateListFormat;

	//
	// The User
	//

	public void noteLogIn(User user) {
		_loggedIn = true;
		_myActiveRoleIds = null;

		noteChanges(user);
	}

	public void noteLogOut() {
		_loggedIn = false;
		_myActiveRoleIds = null;
		
		_myUser = null;
	}

	public void noteChanges(User user) {

		if (user == null) {
			throw new IllegalArgumentException();
		}
		
		_myUser = user;

		_myDateTranslator = new DateTranslator();
		_myDateTranslator.setPattern(user.getDateInputPattern());

		_myDateViewFormat = new SimpleDateFormat(user.getDateViewPattern());

		_myDateListFormat = new SimpleDateFormat(user.getDateListPattern());
	}

	public boolean isLoggedIn() {
		return _loggedIn;
	}

	public Long getMyUserId() {
		return _myUser.getId();
	}

	public String getMyLoginId() {
		return _myUser.getLoginId();
	}

	//
	// The User's roles
	// These are lazy loaded by ProtectedBasePage
	//

	public List<Long> getMyActiveRoleIds() {
		return _myActiveRoleIds;
	}

	public void setMyUserRoles(List<UserRole> userRoles) {
		_myActiveRoleIds = new ArrayList<Long>();

		// Add the active userRoles to my list

		for (UserRole userRole : userRoles) {
			if (userRole.getStatus().getId().equals(UserRole.STATUS_ACTIVE)) {
				_myActiveRoleIds.add(userRole.getRole().getId());
			}
		}
	}

	//
	// Date and time formatting
	//

	public DateTranslator getMyDateTranslator() {
		return _myDateTranslator;
	}

	public Format getMyDateViewFormat() {
		return _myDateViewFormat;
	}

	public Format getMyDateListFormat() {
		return _myDateListFormat;
	}

	//
	// Currency formatting
	//

	public NumberFormat getCurrencyFormat() {
		NumberFormat format = NumberFormat.getInstance();
		format.setMaximumFractionDigits(2);
		format.setMinimumFractionDigits(2);
		return format;
	}

	//
	// Stylesheet
	//

	public int getStyleId() {
		return _myUser.getStyleId();
	}

	//
	// Tapestry Inspector
	//

	public boolean isInspectorEnabled() {
		return _myUser.isShowInspector();
	}

}
